<?php
    // set_include_path('c:\xampp\htdocs\TICO'); 
    include 'c:\xampp\htdocs\TICO\includes\config.inc.php';
    require_once 'c:\xampp\htdocs\vendor\autoload.php' ;
//--------------------------//
//---> Determine Server <---//
//--------------------------//
//function f334678() {
//  $cSystem='' ; 
//    if ($_SERVER['SERVER_NAME'] == 'NGC-VP-LGCY01') {
//        $cSystem = 'NGC-VP-LGCY01' ;
//    } else {
//        $cSystem = 'Local' ; 
//    }
//    return $cSystem ; 
//}

//-----------------------------------//
//----- Find Table Line Count  ------//
//-----------------------------------//
function findlinecount($infile) {
  $linecount = 0 ;
  $handle=fopen($infile, "r") ;
  while (!feof($handle)) {
    $linecount++;
  }
  fclose($handle) ;

  return $linecount ; 

}

//-----------------------------------//
//----- Summary Table Update   ------//
//-----------------------------------//
function summaryupdate($indate) {
    include 'includes\config.inc.php' ;

    $inmth = '0'; 
    $inyr = '0' ; 

    //---> Lets pull Data from the New Detail File <---//
    $stmt = $con->prepare("select acdt, cast(insertdt as Date) as ints, count(*) as Reccnt
                from premhistnew
                where cast(insertdt as Date) = ?
                group by acdt, cast(insertdt as Date) ") ; 
    $stmt->execute([$indate]) ;
    while ($row = $stmt->fetch()) {
      $inacdt = $row['acdt'];
      $ints = $row['ints'] ;
      $reccnt = $row['Reccnt'] ; 
    }
    if($reccnt > 0) {
      $inmth=substr($inacdt,-3,1) ; 
      $inyr=substr($inacdt,-2); 
      $sql = 'INSERT INTO importsummary(importdate, rectype, validcnt, errorcnt, rptmth, rptyr)
              Values(?,?,?,?,?,?)' ;
       $con->prepare($sql)->execute([$ints,'PN',$reccnt,0,$inmth,$inyr]);
    }  
    //---> Lets look at Old Detail File <---//
    $stmt = $con->prepare("select acdt, cast(insertdt as Date) as ints, count(*) as Reccnt
              from premhistold
              where cast(insertdt as Date) = ?
              group by acdt, cast(insertdt as Date) ") ; 
    $stmt->execute([$indate]) ;
    while ($row = $stmt->fetch()) {
      $inacdt = $row['acdt'];
      $ints = $row['ints'] ;
      $reccnt = $row['Reccnt'] ; 
    }
    if ($reccnt > 0) {
      $inmth=substr($inacdt,-2,1) ; 
      $inyr='2'.substr($inacdt,-1); 
      $sql = 'INSERT INTO importsummary(importdate, rectype, validcnt, errorcnt, rptmth, rptyr)
              Values(?,?,?,?,?,?)' ;
      $con->prepare($sql)->execute([$ints,'PO',$reccnt,0,$inmth,$inyr]);
    }
    return  ; 
  }

//-------------------------------//
//----- Check Record Type  ------//
//-------------------------------//
function chkRecTyp($inrectype) {
  $valid=' ';

  switch($inrectype) {
    case '01' :
      $valid='Y' ; 
     break; 
     case '03' :
      $valid='Y' ; 
     break;  
     case '91' :
      $valid='Y' ; 
     break; 
     case '93' :
      $valid='Y' ; 
     break;  
     case '95' :
      $valid='Y' ;
     break;   
    default:
      $valid='N' ;   
  }
  return $valid ; 
}

//-------------------------------//
//----- EBCDIC Conversion -------//
//-------------------------------//
function cvtebc($invar) {
  $inlen=0; 
  $list=array(
    "}"=>-0, 
    "J"=>-1,
    "K"=>-2,
    "L"=>-3,
    "M"=>-4,
    "N"=>-5,
    "O"=>-6,
    "P"=>-7,
    "Q"=>-8,
    "R"=>-9,
    "{"=>0, 
    "A"=>1,
    "B"=>2,
    "C"=>3,
    "D"=>4,
    "E"=>5,
    "F"=>6,
    "G"=>7,
    "H"=>8,
    "I"=>9
    ) ;
      // echo 'IN=> '.$invar; 
      $ebdchar= substr($invar,-1) ;
      $newchar=$list[$ebdchar];  
      if ($newchar<0) {
         $newchar=$newchar*-1;
         $newvar=(str_replace(substr($invar,-1),$newchar,$invar))*-1 ;
      } else {
        $newvar=(str_replace(substr($invar,-1),$newchar,$invar))*1 ;
      }   
      // echo ' Out=> '.$newvar.'<br>';    
    
      return $newvar ; 
    
  } 

//-------------------------------//
//----- Get Summary data  -------//
//-------------------------------//
  function getsummarydata() {
    include 'includes\config.inc.php';
    unset($mtharray) ; 
    unset($yrarray) ;
    unset($cidarray) ;
    unset($dtfarray) ;
    unset($typarray) ;
    unset($recarray) ;
    $x = 0 ;  
    $sql = "SELECT case substring(acdt,1,1) 
                    when  '&' Then  12 
                    When  '-' Then 11 
                    When '0' Then 10
                    else substring(acdt,1,1) 
                    end as Mth, 
                  substring(acdt,2,2) as Yr, CarrierCd, convert(date,insertdt) as datefinal, 'NP' as Type, count(*) ValidRecords
            FROM dbo.premhistnew a
              Left Outer join [NGC-Tico].[dbo].[T_TICOCompany] on [CompanyNumber] = cno  
              group by substring(acdt,1,1), substring(acdt,2,2), [CarrierCd], convert(date,insertdt)
            Union
            ( 
            select case substring(acdt,1,1) 
                    when  '&' Then  12 
                    When  '-' Then 11 
                    When 0 Then 10 
                    else substring(acdt,1,1) 
                    end as Mth, 
                  substring(b.acdt,2,2) as Yr, CarrierCd, convert(date,b.insertdt) as datefinal, 'OP' As Type, count(*) as ValidRecords
	          FROM dbo.premhistold b
	            Left Outer join [NGC-Tico].[dbo].[T_TICOCompany] on [CompanyNumber] = cno  
	            group by substring(acdt,1,1), substring(acdt,2,2), [CarrierCd], convert(date,insertdt)
	          )
            Order by substring(acdt,2,2) desc,Mth desc, [CarrierCd] " ; 

    $stmt = $con->query($sql);  
      while ($row = $stmt->fetch()) {
            $mtharray[$x] = $row['Mth'];
            $yrarray[$x] = $row['Yr'];
            $cidarray[$x] = $row['CarrierCd'];
            $dtfarray[$x] = $row['datefinal'];
            $typarray[$x] = $row['Type'];
            $recarray[$x] = $row['ValidRecords'];
            $x++ ; 
      }
  
            
  return array($mtharray, $yrarray, $cidarray,$dtfarray, $typarray, $recarray)  ;    
}

//----------------------------------//
//----- TICO Submit Process  -------//
//----------------------------------//  
  function ticosubmit($rdate, $carrier, $rpttype)  {
    $dvar = null ; 
    $data = array(
      array($rdate, $carrier, $rpttype)
    ); 

    //---> Create Filename and Path to Store <---//
    $filename = 'sbmdta'.$carrier.$rpttype.'.csv'; 
    // $filename = 'sbmdta.csv'; 
    //--------------> Production <-------------------------// 
    $filepath = 'E:\\Shares\\Tico\\'.$filename; 
    //-----------------------------------------------------//

    //----------------> Test <---------------------//
    //$filepath = 'c:\\IMAGE\\'.$filename; 
    //---------------------------------------------//
    if(file_exists($filepath)) {
      unlink($filepath);
    }
    $fp = fopen($filepath,'w+'); 
    foreach($data as $line) {
      fputcsv($fp, $line,',') ;
    }
    fclose($fp); 

    $dvar='Disabled'; 

    return ($dvar) ; 
 
  }

  //--------------------------------//
  //---> Locate Accepted Tables <---//
  //--------------------------------//
  function TICOatbl($rpttype) {
    
    $x=0; 
    //-------> Developement Path <--------//
    //---> $imgspath = 'C:\Legacy\Tico' ; 
    //------------------------------------//
    //--------------> Production <-----------------------//
	$imgspath = '\\\Ngc-vi-res01\Legacy\Tico' ;
    //---------------------------------------------------//
    if($rpttype === 'P') {
      $imgspath=$imgspath.'\Premium'; 
    } 
    if($rpttype === 'L') {
      $imgspath=$imgspath.'\Loss';
    }
    $_SESSION['tfpath']= $imgspath ; 
	  //--->echo $imgspath.'</br>'; 
    //---> This is the perferd code <---//
   
    if($fh=opendir($imgspath)) {
      while (false !== ($fi = readdir($fh))) {
		// echo "$fi".'</br>'; 
        if($rpttype = 'P') {
          if(strpos($fi,'PREM.txt')==true) {
            $arrFiles[$x]=$fi;
            $x++;
          } 
        }
        if ($rpttype = 'L') {
          if(strpos($fi,'LOSS.txt')==true) {
            $arrFiles[$x]=$fi;
            $x++;
          }    
        }  
      }
    } else {
		echo 'Did not open?'.'</br>'; 
	}
    // print_r($arrFiles); 
	
    if(!empty($arrFiles)){
      return $arrFiles; 
    } else {
      return Null ; 
    }  

  }
 
  //--------------------------------------//
  //--->   Update LSTACCEPTED Table   <---//
  //--------------------------------------//
  function updlstrundte($ingroup,$currentAcceptedDate) {
    include 'includes\config.inc.php';
    $link = new PDO("mysql:host=$DATABASE_HOST;dbname=$DATABASE_NAME",$DATABASE_USER, $DATABASE_PASS);
    $link->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $stmt = $link->prepare('INSERT INTO lstaccepted (lstacpdte, company)
      Values(?, ?)') ;

    $stmt->execute([$currentAcceptedDate, $ingroup]) ; 

    return;   
  }

  //---------------------------------//
  //---> Get Last Final Run Date <---//
  //---------------------------------//
  function getlastrundate() {
    include 'includes\config.inc.php';
    $rtndate = ' ' ;
    

    $pdo = new PDO("mysql:host=$DATABASE_HOST;dbname=$DATABASE_NAME",$DATABASE_USER, $DATABASE_PASS);
    $stmt = $pdo->query('SELECT lstacpdte, count(*) FROM lstaccepted 
	                        group by lstacpdte
	                        order by lstacpdte desc
                          LIMIT 1'); 
    $rtvdate=$stmt->fetch(); 
    $lstdate=strtotime($rtvdate[0]); 
    $rtndate = date("Y",$lstdate).'-'.date('m',$lstdate) ; 
    
    return $rtndate ; 
  }

  //--------------------------------------//
  //---> Determine Correct Final Date <---//
  //--------------------------------------//
  function returnlastrundate($inDate) {
    $orgDate = $inDate;

    $lastdate = date("Y-m-t", strtotime($orgDate)); 
    return $lastdate ; 
  }
?>

